/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.item.BFItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TeaShrubBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_222999_;
    public static BooleanProperty BERRIES = BooleanProperty.m_61465_((String)"berries");
    private static final VoxelShape AGE0_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    private static final VoxelShape AGE1_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);
    private static final VoxelShape AGE2_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Integer)state.m_61143_((Property)AGE)) {
            case 0: {
                return AGE0_SHAPE;
            }
            case 1: {
                return AGE1_SHAPE;
            }
        }
        return AGE2_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.m_61143_((Property)AGE) >= 2 && context.m_6513_(AGE2_SHAPE, pos, false)) {
            return AGE2_SHAPE;
        }
        return Shapes.m_83040_();
    }

    public TeaShrubBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)BERRIES, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, BERRIES});
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!TeaShrubBlock.isFullyGrown(state) && random.m_188501_() < 0.5f) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)AGE), 2);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42574_) && TeaShrubBlock.canHarvestLeaves(state)) {
            itemStack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
            world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if ((Integer)state.m_61143_((Property)AGE) == 4) {
                TeaShrubBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BFItems.TEA_LEAVES, 2 + world.f_46441_.m_188503_(3)));
            } else {
                TeaShrubBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BFItems.TEA_LEAVES, 1 + world.f_46441_.m_188503_(2)));
            }
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2)), 2);
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_(Items.f_42499_) && (Integer)state.m_61143_((Property)AGE) == 4 && !((Boolean)state.m_61143_((Property)BERRIES)).booleanValue()) {
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BERRIES, (Comparable)Boolean.valueOf(true)), 2);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)BERRIES)).booleanValue()) {
            world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BERRIES, (Comparable)Boolean.valueOf(false)), 2);
            TeaShrubBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BFItems.TEA_BERRIES, 1 + world.f_46441_.m_188503_(1)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BFItems.TEA_BERRIES);
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return !TeaShrubBlock.isFullyGrown(state);
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (!TeaShrubBlock.isFullyGrown(state)) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)AGE), 2);
        }
    }

    protected static boolean isFullyGrown(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) == 4;
    }

    protected static boolean canHarvestLeaves(BlockState state) {
        return ((Integer)state.m_61143_((Property)AGE) == 3 || (Integer)state.m_61143_((Property)AGE) == 4) && (Boolean)state.m_61143_((Property)BERRIES) == false;
    }
}

